/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.generic.Interface.curio;

import com.xiaoyue.tinkers_ingenuity.content.library.context.ArrowImpactContext;
import com.xiaoyue.tinkers_ingenuity.content.library.events.ItemStackDamageEvent;
import java.util.Collection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import top.theillusivec4.curios.api.SlotContext;

public interface CurioAddonHook {
    public static final CurioAddonHook EMPTY = new CurioAddonHook(){};

    default public int onCurioGetFortune(IToolStackView curio, SlotContext slotContext, LootContext lootContext, ItemStack stack, int fortune, int level) {
        return fortune;
    }

    default public int onCurioGetLooting(IToolStackView curio, SlotContext slotContext, DamageSource source, LivingEntity target, ItemStack stack, int Looting, int level) {
        return Looting;
    }

    default public void onCurioGetToolDamage(IToolStackView curio, LivingEntity entity, ItemStackDamageEvent event, int level) {
    }

    default public void onCurioTakeHeal(IToolStackView curio, LivingHealEvent event, LivingEntity entity, int level) {
    }

    default public void onCurioShootArrow(IToolStackView curio, LivingEntity shooter, AbstractArrow arrow, int level) {
    }

    default public void onCurioArrowHit(IToolStackView curio, LivingEntity shooter, ArrowImpactContext context, int level) {
    }

    default public void onCurioBreakSpeed(IToolStackView curio, PlayerEvent.BreakSpeed event, Player player, int level) {
    }

    public record AllMerger(Collection<CurioAddonHook> modules) implements CurioAddonHook
    {
        @Override
        public int onCurioGetFortune(IToolStackView curio, SlotContext slotContext, LootContext lootContext, ItemStack stack, int fortune, int level) {
            for (CurioAddonHook module : this.modules) {
                module.onCurioGetFortune(curio, slotContext, lootContext, stack, fortune, level);
            }
            return fortune;
        }

        @Override
        public int onCurioGetLooting(IToolStackView curio, SlotContext slotContext, DamageSource source, LivingEntity target, ItemStack stack, int Looting, int level) {
            for (CurioAddonHook module : this.modules) {
                module.onCurioGetLooting(curio, slotContext, source, target, stack, Looting, level);
            }
            return Looting;
        }

        @Override
        public void onCurioGetToolDamage(IToolStackView curio, LivingEntity entity, ItemStackDamageEvent event, int level) {
            for (CurioAddonHook module : this.modules) {
                module.onCurioGetToolDamage(curio, entity, event, level);
            }
        }

        @Override
        public void onCurioTakeHeal(IToolStackView curio, LivingHealEvent event, LivingEntity entity, int level) {
            for (CurioAddonHook module : this.modules) {
                module.onCurioTakeHeal(curio, event, entity, level);
            }
        }

        @Override
        public void onCurioShootArrow(IToolStackView curio, LivingEntity shooter, AbstractArrow arrow, int level) {
            for (CurioAddonHook module : this.modules) {
                module.onCurioShootArrow(curio, shooter, arrow, level);
            }
        }

        @Override
        public void onCurioArrowHit(IToolStackView curio, LivingEntity shooter, ArrowImpactContext context, int level) {
            for (CurioAddonHook module : this.modules) {
                module.onCurioArrowHit(curio, shooter, context, level);
            }
        }

        @Override
        public void onCurioBreakSpeed(IToolStackView curio, PlayerEvent.BreakSpeed event, Player player, int level) {
            for (CurioAddonHook module : this.modules) {
                module.onCurioBreakSpeed(curio, event, player, level);
            }
        }
    }
}

